unit DPObjectPool.DUnit;
{

  Delphi DUnit Test Case
  ----------------------
  This unit contains a skeleton test case class generated by the Test Case Wizard.
  Modify the generated code to correctly setup and call the methods from the unit
  being tested.

}

interface

uses
  System.SysUtils, System.Generics.Collections,
  TestFramework, DPObjectPool;

type
  // Test methods for class TObjectPool

  TestTObjectPool = class(TTestCase)
  published
    procedure TestFixedSize;
    procedure TestGrowing;
    procedure TestFactory;
  end;

implementation

var
  GNumReleased: integer;

type
  TPoolObject = class
  strict private
    FValue: integer;
  public
    constructor Create; overload;
    constructor Create(value: integer); overload;
    destructor Destroy; override;
    property Value: integer read FValue;
  end;

{ TestTObjectPool }

procedure TestTObjectPool.TestFixedSize;
var
  i: integer;
  objs: array [1..5] of TPoolObject;
  pool: TObjectPool<TPoolObject>;
  rpt: integer;
begin
  pool := TObjectPool<TPoolObject>.Create(3);
  try
    for rpt := 1 to 3 do begin
      for i := Low(objs) to High(objs) do
        objs[i] := pool.Allocate;

      for i := 1 to 3 do
        CheckTrue(nil <> objs[i]);
      for i := 4 to 5 do
        CheckTrue(nil = objs[i]);

      CheckTrue(objs[1] <> objs[2]);
      CheckTrue(objs[1] <> objs[3]);
      CheckTrue(objs[2] <> objs[3]);

      GNumReleased := 0;

      for i := 1 to 3 do
        pool.Release(objs[i]);

      CheckEquals(0, GNumReleased);
    end;
  finally
    FreeAndNil(pool);
  end;

  CheckEquals(3, GNumReleased);
end;

procedure TestTObjectPool.TestGrowing;
var
  i: integer;
  objs: array [1..5] of TPoolObject;
  pool: TObjectPool<TPoolObject>;
  rpt: integer;
  j: Integer;
begin
  pool := TObjectPool<TPoolObject>.Create(0);
  try
    for rpt := 1 to 3 do begin
      for i := Low(objs) to High(objs) do
        objs[i] := pool.Allocate;

      for i := 1 to 5 do begin
        CheckTrue(nil <> objs[i]);
        for j := i+1 to 5 do
          CheckTrue(objs[i] <> objs[j]);
      end;

      GNumReleased := 0;

      for i := 1 to 5 do
        pool.Release(objs[i]);

      CheckEquals(0, GNumReleased);
    end;
  finally
    FreeAndNil(pool);
  end;

  CheckEquals(5, GNumReleased);
end;

procedure TestTObjectPool.TestFactory;
var
  obj: TPoolObject;
  pool: TObjectPool<TPoolObject>;
  makeCustom: TFunc<TPoolObject>;
begin
  // test all possible constructor combinations

  pool := TObjectPool<TPoolObject>.Create;
  try
    obj := pool.Allocate;
    CheckEquals(1, obj.Value);
  finally
    FreeAndNil(pool);
  end;

  pool := TObjectPool<TPoolObject>.Create(3);
  try
    obj := pool.Allocate;
    CheckEquals(1, obj.Value);
  finally
    FreeAndNil(pool);
  end;

  makeCustom :=
    function: TPoolObject
    begin
      Result := TPoolObject.Create(42);
    end;

  pool := TObjectPool<TPoolObject>.Create(makeCustom);
  try
    obj := pool.Allocate;
    CheckEquals(42, obj.Value);
  finally
    FreeAndNil(pool);
  end;


  pool := TObjectPool<TPoolObject>.Create(3, makeCustom);
  try
    obj := pool.Allocate;
    CheckEquals(42, obj.Value);
  finally
    FreeAndNil(pool);
  end;
end;

{ TPoolObject }

constructor TPoolObject.Create;
begin
  inherited Create;
  FValue := 1;
end;

constructor TPoolObject.Create(value: integer);
begin
  inherited Create;
  FValue := value;
end;

destructor TPoolObject.Destroy;
begin
  Inc(GNumReleased);
  inherited;
end;

initialization
  // Register any test cases with the test runner
  RegisterTest(TestTObjectPool.Suite);
end.

